<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('category_id', 'name', 'description', 'price', 'stock', 'weight', 'length', 'width', 'height');
    protected $visible = array('category_id', 'name', 'description', 'price', 'stock', 'weight', 'length', 'width', 'height');

    public function category()
    {
        return $this->hasOne('Category');
    }

    public function patrimonies()
    {
        return $this->hasMany('Patrimony');
    }

    public function variants()
    {
        return $this->hasMany('Variant');
    }

}